	% Example 9.6
	clear all
	close all
	wsT= 0.55*pi; Amin = 50;
	N = CA_ORDER_HB_Z(wsT, Amin)
	N = 9
	[G, Z, P, wcT, wsT, Amax, Amin] = CA_POLES_HB_Z(wsT, Amin, N)	
	wcT/pi
	wsT/pi
	figure(1)
	PLOT_PZ_Z(Z, P)
	
	% Compute attenuation and group delay
	wT = linspace(0, pi, 1000);
	Att = PZ_2_ATT_Z(G, Z, P, wT);
	Taug = PZ_2_TG_Z(G, Z, P, wT);
	figure(2)
	subplot('position', [0.11 0.4 0.88 0.5]);
	axis_Amax = 80;
	axis_Tg_max = 40;
	PLOT_ATT_TG_Z(Att, Taug, wT, axis_Amax, axis_Tg_max)
	% Standard settings
	fs = 16; % Font size
	lw = 1; % Linewidth
	fn = 'times'; % Font
	text(0.3, 10.5,'{\it\tau_g}({\ite^j^\omega^T })','FontName',fn,'FontSize',fs);	
	text(1.8, 20,'{\itA}({\ite^j^\omega^T})','FontName',fn,'FontSize',fs);
	
	
